/*
 * Decompiled with CFR 0.152.
 */
package jclass.base;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import jclass.base.Border;
import jclass.util.JCEnvironment;

public abstract class BaseComponent
extends Canvas {
    public static final int NOVALUE = -999;
    public static final char BELL = '\u0007';
    public static final char BS = '\b';
    public static final char TAB = '\t';
    public static final char ENTER = '\n';
    public static final char DELETE = '\u007f';
    public static final char ESC = '\u001b';
    protected transient Applet applet;
    protected transient AppletContext applet_context;
    protected transient boolean in_repaint = false;
    protected transient boolean needs_layout = true;
    protected int border = 2;
    protected int border_style = 3;
    protected static final Object LOCK = new Object();
    protected boolean double_buffer = true;
    protected boolean has_focus = false;
    protected Object userdata;
    protected Insets insets = new Insets(0, 0, 0, 0);
    protected boolean do_repaint = true;
    protected static boolean use_system_colors;
    protected transient Rectangle paint_rect;
    protected transient Image dblbuffer_image;
    protected transient Graphics dblbuffer_image_gc;
    protected transient boolean realized = false;
    protected Rectangle rect = new Rectangle();
    protected static Hashtable images;

    public BaseComponent() {
        this(null, null);
    }

    public BaseComponent(Applet applet, String string) {
        this.applet = applet;
        this.setName(string);
    }

    public static void useSystemColors(boolean bl) {
        use_system_colors = bl;
    }

    public Object getAWTLock() {
        return this.getTreeLock();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public int getBorderThickness() {
        return this.border;
    }

    public void setBorderThickness(int n) {
        this.border = n;
        this.doLayout();
        this.repaint();
    }

    public int getBorderStyle() {
        return this.border_style;
    }

    public void setBorderStyle(int n) {
        this.border_style = n;
        this.doLayout();
        this.repaint();
    }

    public int getShadowThickness() {
        return this.getBorderThickness();
    }

    public void setShadowThickness(int n) {
        this.setBorderThickness(n);
    }

    public void setInsets(Insets insets) {
        BaseComponent baseComponent = this;
        synchronized (baseComponent) {
            this.insets = insets;
        }
        this.doLayout();
        this.repaint();
    }

    public Insets insets() {
        return this.insets;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Frame getFrame() {
        return BaseComponent.getFrame(this);
    }

    public Object getUserData() {
        return this.userdata;
    }

    public int getUserDataInt() {
        if (this.userdata instanceof Integer) {
            return (Integer)this.userdata;
        }
        return 0;
    }

    public void setUserData(Object object) {
        this.userdata = object;
    }

    public Image getDoubleBufferImage() {
        return this.dblbuffer_image;
    }

    public Graphics getDoubleBufferGraphics() {
        Object object = this.getAWTLock();
        synchronized (object) {
            Image image = this.dblbuffer_image;
            this.dblbuffer_image = BaseComponent.createImage(this, this.getSize().width, this.getSize().height);
            if (this.dblbuffer_image == null) {
                this.dblbuffer_image_gc = null;
            } else if (this.dblbuffer_image != image) {
                this.dblbuffer_image_gc = this.dblbuffer_image.getGraphics();
            }
            Graphics graphics = this.dblbuffer_image_gc;
            Object var3_4 = null;
            return graphics;
        }
    }

    public boolean isShowing() {
        if (JCEnvironment.isJavaOS()) {
            return true;
        }
        return super.isShowing();
    }

    public void repaint() {
        this.repaint(0, 0, this.getSize().width, this.getSize().height);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        this.repaint(graphics, n, n2, n3, n4);
        if (graphics != null) {
            graphics.dispose();
        }
    }

    public void repaint(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics == null) {
            return;
        }
        this.in_repaint = true;
        graphics.setClip(n, n2, n3, n4);
        try {
            this.paint(graphics);
            Object var7_7 = null;
            this.in_repaint = false;
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.in_repaint = false;
            throw throwable;
        }
    }

    public abstract void paint(Graphics var1);

    public void repaint(int n, int n2, int n3, int n4) {
        if (!this.isRealized() || !this.isShowing() || n3 <= 0 || n4 <= 0 || this.in_repaint) {
            return;
        }
        int n5 = this.getSize().width;
        int n6 = this.getSize().height;
        if (n5 <= n || n6 <= n2 || n + n3 < 0 || n2 + n4 < 0) {
            return;
        }
        if (n + n3 > n5) {
            n3 = n5 - n;
        }
        if (n2 + n4 > n6) {
            n4 = n6 - n2;
        }
        super.repaint(n, n2, n3, n4);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateParent() {
        if (this.getParent() != null) {
            this.invalidate();
            this.getParent().invalidate();
            this.getParent().validate();
        }
    }

    protected void paintComponent(Graphics graphics) {
    }

    protected void fillBackground(Graphics graphics) {
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    protected final boolean intersects(Rectangle rectangle, int n) {
        if (rectangle == null) {
            return true;
        }
        int n2 = n;
        int n3 = n;
        int n4 = n3 + this.getSize().height - 2 * n;
        int n5 = n2 + this.getSize().width - 2 * n;
        return n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width || n5 >= rectangle.x && n5 <= rectangle.x + rectangle.width || n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height || n4 >= rectangle.y && n4 <= rectangle.y + rectangle.height;
    }

    protected void drawBorder(Graphics graphics) {
        if (!this.intersects(this.paint_rect, this.border)) {
            return;
        }
        Border.draw(graphics, this.border_style, this.border, 0, 0, this.getSize().width, this.getSize().height, this.getBackground(), this.getForeground());
    }

    public void printAll(Graphics graphics) {
        boolean bl = this.double_buffer;
        this.double_buffer = false;
        super.printAll(graphics);
        this.double_buffer = bl;
    }

    public void addNotify() {
        if (!this.realized) {
            if (use_system_colors) {
                if (this.getBackground() == null) {
                    this.setBackground(SystemColor.control);
                }
                if (this.getForeground() == null) {
                    this.setForeground(SystemColor.controlText);
                }
            }
            super.addNotify();
            this.realized = true;
        }
        if (this.applet == null) {
            this.applet = BaseComponent.getApplet(this);
        }
        this.applet_context = this.getAppletContext();
        this.enableEvents(28L);
    }

    public void removeNotify() {
        super.removeNotify();
        this.realized = false;
    }

    public AppletContext getAppletContext() {
        return BaseComponent.getAppletContext(this.applet);
    }

    public boolean getDoubleBuffer() {
        return this.double_buffer;
    }

    public void setDoubleBuffer(boolean bl) {
        this.double_buffer = bl;
    }

    public boolean hasFocus() {
        return this.has_focus;
    }

    public boolean lostFocus102(Event event, Object object) {
        this.has_focus = false;
        return true;
    }

    public boolean gotFocus102(Event event, Object object) {
        return true;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        Event event = new Event(this, 0L, focusEvent.getID(), 0, 0, 0, 0);
        switch (event.id) {
            case 1005: {
                this.lostFocus102(event, this);
                break;
            }
            case 1004: {
                this.gotFocus102(event, this);
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    public void validate() {
        if (this.isValid() || !this.isRealized()) {
            return;
        }
        super.validate();
        if (JCEnvironment.getJavaVersion() >= 110 || JCEnvironment.isJavaOS()) {
            this.doLayout();
        }
    }

    public Image createImage(int n, int n2) {
        Dimension dimension = this.getToolkit().getScreenSize();
        n = Math.max(1, Math.min(n, dimension.width));
        n2 = Math.max(1, Math.min(n2, dimension.height));
        Image image = null;
        try {
            image = super.createImage(n, n2);
        }
        catch (Throwable throwable) {}
        return image;
    }

    public void copyArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public static Frame getFrame(Component component) {
        Window window = BaseComponent.getWindow(component);
        if (window instanceof Dialog && window.getParent() instanceof Window) {
            window = (Window)window.getParent();
        }
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    public static synchronized Image createImage(Component component, Image image, int n, int n2) {
        Dimension dimension = component.getToolkit().getScreenSize();
        n = Math.max(1, Math.min(n, dimension.width));
        n2 = Math.max(1, Math.min(n2, dimension.height));
        try {
            if (image == null || image.getWidth(null) < n || image.getHeight(null) < n2) {
                image = component.createImage(n, n2);
            }
        }
        catch (Throwable throwable) {}
        return image;
    }

    public static synchronized Image createImage(Component component, int n, int n2) {
        Thread thread;
        Enumeration enumeration = images.keys();
        while (enumeration.hasMoreElements()) {
            thread = (Thread)enumeration.nextElement();
            if (thread.isAlive()) continue;
            images.remove(thread);
        }
        thread = Thread.currentThread();
        Image image = (Image)images.get(thread);
        Image image2 = BaseComponent.createImage(component, image, n, n2);
        if (image2 != image) {
            images.remove(thread);
            if (image2 != null) {
                images.put(thread, image2);
            }
        }
        return image2;
    }

    public static Point translateToParent(Container container, Component component, int n, int n2) {
        while (component != null && component != container) {
            n += component.getLocation().x;
            n2 += component.getLocation().y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    public static Point translateFromParent(Container container, Component component, int n, int n2) {
        while (component != null && component != container) {
            n -= component.getLocation().x;
            n2 -= component.getLocation().y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    public static Point getVisibleScreenLoc(Component component, int n, int n2, int n3, int n4) {
        Point point = BaseComponent.translateToParent(null, component, n, n2);
        Dimension dimension = component.getToolkit().getScreenSize();
        point.x = Math.max(0, Math.min(point.x, dimension.width - n3));
        point.y = Math.max(0, Math.min(point.y, dimension.height - n4));
        return point;
    }

    public static Window getWindow(Component component) {
        Component component2 = component;
        Component component3 = component;
        while (component3 != null && !(component3 instanceof Window)) {
            component3 = component2;
            if (component2 == null) {
                return null;
            }
            component2 = component2.getParent();
        }
        return (Window)component3;
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public boolean isRealized() {
        return this.realized;
    }

    public static Applet getApplet(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        Container container2 = component.getParent();
        while (container2 != null && !(container2 instanceof Applet)) {
            container2 = container;
            container = container == null ? null : container.getParent();
        }
        return (Applet)container2;
    }

    public static AppletContext getAppletContext(Applet applet) {
        if (applet != null) {
            try {
                return applet.getAppletContext();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    static {
        images = new Hashtable(5);
    }
}

